﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class ProductsDB
    {
        public static Products GetItem(Guid productsID, string keyword)
        {
            Products myProducts = null;

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductsID", ((productsID != Guid.Empty && productsID != null) ? productsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            myProducts = SQLHelper.RetrieveObject<Products>("spGetProducts", parameters);
            myProducts.ProductsXCategoryList = ProductsXCategoryDB.GetList(Guid.Empty, myProducts.UniqueID, Guid.Empty);
            myProducts.ProductMeasurementList = ProductsXMeasurementsDB.GetList(Guid.Empty, myProducts.UniqueID);


            return myProducts;
        }

        public static List<Products> GetList(Guid productsID, string keyword)
        {
            List<Products> myList = null;

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductsID", ((productsID != Guid.Empty && productsID != null) ? productsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            myList = SQLHelper.RetrieveList<Products>("spGetProducts", parameters);

            foreach (Products currentProduct in myList)
            {
                currentProduct.ProductsXCategoryList = ProductsXCategoryDB.GetList(Guid.Empty, currentProduct.UniqueID, Guid.Empty);
                currentProduct.ProductMeasurementList = ProductsXMeasurementsDB.GetList(Guid.Empty, currentProduct.UniqueID);

            }
            return myList;
        }

        public static DataTable GetDataTable(Guid productsID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductsID", ((productsID != Guid.Empty && productsID != null) ? productsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataTable("spGetProducts", parameters);

        }

        public static DataSet GetDataSet(Guid productsID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductsID", ((productsID != Guid.Empty && productsID != null) ? productsID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

            return SQLHelper.ExecuteDataSet("spGetProducts", parameters);

        }

        public static void Save(Products myProducts)
        {
            myProducts.Mode = ((myProducts.UniqueID != Guid.Empty && myProducts.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myProducts.UniqueID = ((myProducts.UniqueID != Guid.Empty && myProducts.UniqueID != null) ? myProducts.UniqueID : Guid.NewGuid());
            if (myProducts.Mode == GlobalConfigurations.Mode.Insert)
            {
                myProducts.IsActive = true;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductsID", myProducts.UniqueID));
            parameters.Add(new SqlParameter("@ProductCategoryID", ((myProducts.ProductCategoryID != Guid.Empty && myProducts.ProductCategoryID != null) ? myProducts.ProductCategoryID : (object)DBNull.Value)));
            //parameters.Add(new SqlParameter("@ProductSubCategoryID", ((myProducts.ProductSubCategoryID != Guid.Empty && myProducts.ProductSubCategoryID != null) ? myProducts.ProductSubCategoryID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ProductBrandID", ((myProducts.ProductBrandID != Guid.Empty && myProducts.ProductBrandID != null) ? myProducts.ProductBrandID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ProductColorID", ((myProducts.ProductColorID != Guid.Empty && myProducts.ProductColorID != null) ? myProducts.ProductColorID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ProductMeasurementID", ((myProducts.ProductMeasurementID != Guid.Empty && myProducts.ProductMeasurementID != null) ? myProducts.ProductMeasurementID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ProductName", (string.IsNullOrEmpty(myProducts.ProductName) ? (object)DBNull.Value : myProducts.ProductName)));
            parameters.Add(new SqlParameter("@ProductDescriptions", (string.IsNullOrEmpty(myProducts.ProductDescriptions) ? (object)DBNull.Value : myProducts.ProductDescriptions)));
            parameters.Add(new SqlParameter("@ProductDescriptionsForQuote", (string.IsNullOrEmpty(myProducts.ProductDescriptionsForQuote) ? (object)DBNull.Value : myProducts.ProductDescriptionsForQuote)));
            parameters.Add(new SqlParameter("@ProductCode", (string.IsNullOrEmpty(myProducts.ProductCode) ? (object)DBNull.Value : myProducts.ProductCode)));
            parameters.Add(new SqlParameter("@AdditionalInfo", (string.IsNullOrEmpty(myProducts.AdditionalInfo) ? (object)DBNull.Value : myProducts.AdditionalInfo)));
            parameters.Add(new SqlParameter("@ProductHeight", (myProducts.ProductHeight == 0) ? (object)DBNull.Value : myProducts.ProductHeight));
            parameters.Add(new SqlParameter("@ProductDepth", (myProducts.ProductDepth == 0) ? (object)DBNull.Value : myProducts.ProductDepth));
            parameters.Add(new SqlParameter("@ProductWidth", (myProducts.ProductWidth == 0) ? (object)DBNull.Value : myProducts.ProductWidth));
            parameters.Add(new SqlParameter("@ProductWeight", (myProducts.ProductWeight == 0) ? (object)DBNull.Value : myProducts.ProductWeight));
            parameters.Add(new SqlParameter("@UnitPrice", (myProducts.UnitPrice == 0) ? (object)DBNull.Value : myProducts.UnitPrice));
            parameters.Add(new SqlParameter("@ShowProductPrice", myProducts.ShowProductPrice));
            parameters.Add(new SqlParameter("@Image1", (string.IsNullOrEmpty(myProducts.Image1) ? (object)DBNull.Value : myProducts.Image1)));
            parameters.Add(new SqlParameter("@Image2", (string.IsNullOrEmpty(myProducts.Image2) ? (object)DBNull.Value : myProducts.Image2)));
            parameters.Add(new SqlParameter("@Image3", (string.IsNullOrEmpty(myProducts.Image3) ? (object)DBNull.Value : myProducts.Image3)));
            parameters.Add(new SqlParameter("@Image4", (string.IsNullOrEmpty(myProducts.Image4) ? (object)DBNull.Value : myProducts.Image4)));
            parameters.Add(new SqlParameter("@Image5", (string.IsNullOrEmpty(myProducts.Image5) ? (object)DBNull.Value : myProducts.Image5)));
            parameters.Add(new SqlParameter("@URLFor3DView", (string.IsNullOrEmpty(myProducts.URLFor3DView) ? (object)DBNull.Value : myProducts.URLFor3DView)));
            parameters.Add(new SqlParameter("@DesignerInfo", (string.IsNullOrEmpty(myProducts.DesignerInfo) ? (object)DBNull.Value : myProducts.DesignerInfo)));
            parameters.Add(new SqlParameter("@EarliestAvailableDays", (myProducts.EarliestAvailableDays == 0) ? (object)DBNull.Value : myProducts.EarliestAvailableDays));
            parameters.Add(new SqlParameter("@ActualStock", (myProducts.ActualStock == 0) ? (object)DBNull.Value : myProducts.ActualStock));
            parameters.Add(new SqlParameter("@ReserveStock", (myProducts.ReserveStock == 0) ? (object)DBNull.Value : myProducts.ReserveStock));
            parameters.Add(new SqlParameter("@LowStockIndication", (myProducts.LowStockIndication == 0) ? (object)DBNull.Value : myProducts.LowStockIndication));
            parameters.Add(new SqlParameter("@PromoSalesQty", (myProducts.PromoSalesQty == 0) ? (object)DBNull.Value : myProducts.PromoSalesQty));
            parameters.Add(new SqlParameter("@IsNew", myProducts.IsNew));
            parameters.Add(new SqlParameter("@IsBestSales", myProducts.IsBestSales));
            parameters.Add(new SqlParameter("@IsSales", myProducts.IsSales));
            parameters.Add(new SqlParameter("@IsMiscellaneous", myProducts.IsMiscellaneous));
            //parameters.Add(new SqlParameter("@IsShowInShop", myProducts.IsShowInShop));
            parameters.Add(new SqlParameter("@ProductWarrenty", (myProducts.ProductWarrenty == 0) ? (object)DBNull.Value : myProducts.ProductWarrenty));
            parameters.Add(new SqlParameter("@SequenceNo", (myProducts.SequenceNo == 0) ? (object)DBNull.Value : myProducts.SequenceNo));
            parameters.Add(new SqlParameter("@CreatedBy", ((myProducts.UserAccountID != Guid.Empty && myProducts.UserAccountID != null) ? myProducts.UserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", myProducts.IsActive));
            //parameters.Add(new SqlParameter("@IsDeleted", myProductCategory.IsDeleted));
            parameters.Add(new SqlParameter("@Mode", myProducts.Mode));
            parameters.Add(new SqlParameter("@HappyHourPrice", (myProducts.HappyHourPrice == 0) ? (object)DBNull.Value : myProducts.HappyHourPrice));
            parameters.Add(new SqlParameter("@ShareInventoryID", ((myProducts.ShareInventoryID != Guid.Empty && myProducts.ShareInventoryID != null) ? myProducts.ShareInventoryID : (object)DBNull.Value)));
            SQLHelper.ExecuteQuery("spAddOrUpdateProducts", parameters);

        }

        public static void SaveLocal(Products myProducts)
        {
            myProducts.Mode = ((myProducts.UniqueID != Guid.Empty && myProducts.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myProducts.UniqueID = ((myProducts.UniqueID != Guid.Empty && myProducts.UniqueID != null) ? myProducts.UniqueID : Guid.NewGuid());
            if (myProducts.Mode == GlobalConfigurations.Mode.Insert)
            {
                myProducts.IsActive = true;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductsID", myProducts.UniqueID));
            parameters.Add(new SqlParameter("@ProductCategoryID", ((myProducts.ProductCategoryID != Guid.Empty && myProducts.ProductCategoryID != null) ? myProducts.ProductCategoryID : (object)DBNull.Value)));
            //parameters.Add(new SqlParameter("@ProductSubCategoryID", ((myProducts.ProductSubCategoryID != Guid.Empty && myProducts.ProductSubCategoryID != null) ? myProducts.ProductSubCategoryID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ProductBrandID", ((myProducts.ProductBrandID != Guid.Empty && myProducts.ProductBrandID != null) ? myProducts.ProductBrandID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ProductColorID", ((myProducts.ProductColorID != Guid.Empty && myProducts.ProductColorID != null) ? myProducts.ProductColorID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ProductMeasurementID", ((myProducts.ProductMeasurementID != Guid.Empty && myProducts.ProductMeasurementID != null) ? myProducts.ProductMeasurementID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ProductName", (string.IsNullOrEmpty(myProducts.ProductName) ? (object)DBNull.Value : myProducts.ProductName)));
            parameters.Add(new SqlParameter("@ProductDescriptions", (string.IsNullOrEmpty(myProducts.ProductDescriptions) ? (object)DBNull.Value : myProducts.ProductDescriptions)));
            parameters.Add(new SqlParameter("@ProductDescriptionsForQuote", (string.IsNullOrEmpty(myProducts.ProductDescriptionsForQuote) ? (object)DBNull.Value : myProducts.ProductDescriptionsForQuote)));
            parameters.Add(new SqlParameter("@ProductCode", (string.IsNullOrEmpty(myProducts.ProductCode) ? (object)DBNull.Value : myProducts.ProductCode)));
            parameters.Add(new SqlParameter("@AdditionalInfo", (string.IsNullOrEmpty(myProducts.AdditionalInfo) ? (object)DBNull.Value : myProducts.AdditionalInfo)));
            parameters.Add(new SqlParameter("@ProductHeight", (myProducts.ProductHeight == 0) ? (object)DBNull.Value : myProducts.ProductHeight));
            parameters.Add(new SqlParameter("@ProductDepth", (myProducts.ProductDepth == 0) ? (object)DBNull.Value : myProducts.ProductDepth));
            parameters.Add(new SqlParameter("@ProductWidth", (myProducts.ProductWidth == 0) ? (object)DBNull.Value : myProducts.ProductWidth));
            parameters.Add(new SqlParameter("@ProductWeight", (myProducts.ProductWeight == 0) ? (object)DBNull.Value : myProducts.ProductWeight));
            parameters.Add(new SqlParameter("@UnitPrice", (myProducts.UnitPrice == 0) ? (object)DBNull.Value : myProducts.UnitPrice));
            parameters.Add(new SqlParameter("@ShowProductPrice", myProducts.ShowProductPrice));
            parameters.Add(new SqlParameter("@Image1", (string.IsNullOrEmpty(myProducts.Image1) ? (object)DBNull.Value : myProducts.Image1)));
            parameters.Add(new SqlParameter("@Image2", (string.IsNullOrEmpty(myProducts.Image2) ? (object)DBNull.Value : myProducts.Image2)));
            parameters.Add(new SqlParameter("@Image3", (string.IsNullOrEmpty(myProducts.Image3) ? (object)DBNull.Value : myProducts.Image3)));
            parameters.Add(new SqlParameter("@Image4", (string.IsNullOrEmpty(myProducts.Image4) ? (object)DBNull.Value : myProducts.Image4)));
            parameters.Add(new SqlParameter("@Image5", (string.IsNullOrEmpty(myProducts.Image5) ? (object)DBNull.Value : myProducts.Image5)));
            parameters.Add(new SqlParameter("@URLFor3DView", (string.IsNullOrEmpty(myProducts.URLFor3DView) ? (object)DBNull.Value : myProducts.URLFor3DView)));
            parameters.Add(new SqlParameter("@DesignerInfo", (string.IsNullOrEmpty(myProducts.DesignerInfo) ? (object)DBNull.Value : myProducts.DesignerInfo)));
            parameters.Add(new SqlParameter("@EarliestAvailableDays", (myProducts.EarliestAvailableDays == 0) ? (object)DBNull.Value : myProducts.EarliestAvailableDays));
            parameters.Add(new SqlParameter("@ActualStock", (myProducts.ActualStock == 0) ? (object)DBNull.Value : myProducts.ActualStock));
            parameters.Add(new SqlParameter("@ReserveStock", (myProducts.ReserveStock == 0) ? (object)DBNull.Value : myProducts.ReserveStock));
            parameters.Add(new SqlParameter("@LowStockIndication", (myProducts.LowStockIndication == 0) ? (object)DBNull.Value : myProducts.LowStockIndication));
            parameters.Add(new SqlParameter("@PromoSalesQty", (myProducts.PromoSalesQty == 0) ? (object)DBNull.Value : myProducts.PromoSalesQty));
            parameters.Add(new SqlParameter("@IsNew", myProducts.IsNew));
            parameters.Add(new SqlParameter("@IsBestSales", myProducts.IsBestSales));
            parameters.Add(new SqlParameter("@IsSales", myProducts.IsSales));
            parameters.Add(new SqlParameter("@IsMiscellaneous", myProducts.IsMiscellaneous));
            //parameters.Add(new SqlParameter("@IsShowInShop", myProducts.IsShowInShop));
            parameters.Add(new SqlParameter("@ProductWarrenty", (myProducts.ProductWarrenty == 0) ? (object)DBNull.Value : myProducts.ProductWarrenty));
            parameters.Add(new SqlParameter("@SequenceNo", (myProducts.SequenceNo == 0) ? (object)DBNull.Value : myProducts.SequenceNo));
            parameters.Add(new SqlParameter("@CreatedBy", ((myProducts.UserAccountID != Guid.Empty && myProducts.UserAccountID != null) ? myProducts.UserAccountID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", myProducts.IsActive));
            //parameters.Add(new SqlParameter("@IsDeleted", myProductCategory.IsDeleted));
            parameters.Add(new SqlParameter("@Mode", myProducts.Mode));
            parameters.Add(new SqlParameter("@HappyHourPrice", (myProducts.HappyHourPrice == 0) ? (object)DBNull.Value : myProducts.HappyHourPrice));
            parameters.Add(new SqlParameter("@ShareInventoryID", ((myProducts.ShareInventoryID != Guid.Empty && myProducts.ShareInventoryID != null) ? myProducts.ShareInventoryID : (object)DBNull.Value)));
            SQLHelper.ExecuteOfflineQuery("spAddOrUpdateProducts", parameters);

        }


        public static bool Delete()
        {
            //if (GlobalConfigurations.AppConfiguration.IsLocalDatabase)
            //{
            try
            {
                string SQL = string.Empty;
                SQL = @"DELETE FROM Products";
                SQLHelper.ExecuteQueryStatement(SQL.ToString());
            }
            catch
            {
                return false;
            }
            return true;
            //}
        }
    }
}
